IF NOT OBJECT_ID('[TRG_EST_PROD_INATIVACAO]') IS NULL
	BEGIN 
		DROP TRIGGER [TRG_EST_PROD_INATIVACAO]
	END

GO

  
CREATE TRIGGER [dbo].[TRG_EST_PROD_INATIVACAO] ON [dbo].[EST_PROD] FOR UPDATE AS  
begin  
if update(STS_PROD)  
 begin  
  --Probe alterao na nota fiscal de sada quando j existe registro da transferncia  
  
  IF EXISTS(SELECT D.CD_EMP 
			  FROM DELETED D
				INNER JOIN INSERTED I ON 
					D.CD_PROD = I.CD_PROD
					AND D.CD_EMP = I.CD_EMP
			  WHERE D.STS_PROD <> I.STS_PROD)
  BEGIN
		  IF EXISTS (SELECT   
			 TOP 1 *   
			  FROM   
			 INSERTED i INNER JOIN EST_PROD_CPL ON  
			 i.CD_EMP = EST_PROD_CPL.CD_EMP AND  
			 i.CD_PROD = EST_PROD_CPL.CD_PROD  
			  WHERE  
				EST_PROD_CPL.QT_EST <> 0  
				AND i.STS_PROD=1  
			 )  
			begin  
		   RAISERROR ('Produto com estoque diferente de zero em alguma filial, nao podera ser inativado.',16, 1);   
		   RETURN;  
			end   
		 end
  END  
end